<?php
namespace App\Controllers;

use App\Models\Database;
use App\Helpers\Keyboard;
use App\Config\Config;
use PDO;

class AdminController {
    private $db;
    private $chatId;
    private $messageId;
    private $isAdmin;
    private $isMainAdmin; // 👈 این خط اضافه شد

public function __construct($chatId, $messageId = null, $isMainAdmin = false) {
        $this->db = Database::getInstance();
        $this->chatId = $chatId;
        $this->messageId = $messageId;
        $this->isMainAdmin = $isMainAdmin; // دریافت وضعیت ادمین کل
    }

    // تغییر مرحله کاربر (ذخیره وضعیت)
    public function setStep($step, $data = null) {
        $sql = "UPDATE users SET step = :step";
        if ($data !== null) $sql .= ", temp_data = :data";
        else $sql .= ", temp_data = NULL"; 
        $sql .= " WHERE chat_id = :id";
        
        $stmt = $this->db->prepare($sql);
        $params = [':step' => $step, ':id' => $this->chatId];
        if ($data !== null) $params[':data'] = $data;
        $stmt->execute($params);
    }

    // ====================================================
    //            مدیریت درخواست‌های ادمین
    // ====================================================
    public function handleRequest($text, $currentStep, $tempData) {
        
        // --- دکمه‌های بازگشت عمومی ---
        
        // 1. خروج از پنل ادمین به پنل کاربری
        if ($text == '🔙 بازگشت به پنل کاربری') {
            $this->setStep('none');
            return ["به منوی اصلی بازگشتید.", Keyboard::mainMenu(true)];
        }

        // 2. بازگشت به منوی مدیریت
        if ($text == '❌ انصراف' || $text == '🔙 بازگشت به پنل مدیریت' || $text == '🔙 بازگشت' || $text == 'back_to_admin_main') {
            $this->setStep('none');
            return ["به پنل مدیریت بازگشتید.", Keyboard::adminPanel()];
        }

        // ====================================================
        //              مدیریت مراحل (STEPS LOGIC)
        // ====================================================
        if ($currentStep != 'none') {
            switch ($currentStep) {
                
                case 'awaiting_add_admin_id':
                    $newAdminId = $this->cleanNumber($text);
                    if (!is_numeric($newAdminId)) return ["⚠️ لطفاً فقط آیدی عددی بفرستید.", Keyboard::cancel()];
                    
                    $stmt = $this->db->prepare("SELECT value FROM settings WHERE `key` = 'bot_admins'");
                    $stmt->execute();
                    $currentAdmins = $stmt->fetchColumn();
                    $adminsArr = $currentAdmins ? explode(',', $currentAdmins) : [];
                    
                    if (in_array($newAdminId, $adminsArr) || in_array($newAdminId, \App\Config\Config::ADMIN_IDS)) {
                        $this->setStep('none');
                        return ["⚠️ این کاربر از قبل ادمین است.", Keyboard::adminPanel()];
                    }
                    
                    $adminsArr[] = $newAdminId;
                    $this->saveSetting('bot_admins', implode(',', $adminsArr));
                    $this->setStep('none');
                    return ["✅ کاربر <code>$newAdminId</code> با موفقیت به عنوان ادمین فرعی اضافه شد.", Keyboard::adminPanel()];
                    
case 'awaiting_remove_admin_selection':
                    if ($text == 'back_to_admin_main' || $text == '❌ انصراف') {
                        $this->setStep('none');
                        return ["به پنل مدیریت بازگشتید.", Keyboard::adminPanel()];
                    }
                    
                    if (strpos($text, 'del_admin_') === 0) {
                        $remAdminId = str_replace('del_admin_', '', $text);
                        
                        $stmt = $this->db->prepare("SELECT value FROM settings WHERE `key` = 'bot_admins'");
                        $stmt->execute();
                        $currentAdmins = $stmt->fetchColumn();
                        $adminsArr = $currentAdmins ? explode(',', $currentAdmins) : [];
                        
                        if (!in_array($remAdminId, $adminsArr)) {
                            $this->setStep('none');
                            return ["⚠️ این کاربر در لیست ادمین‌های فرعی نیست.", Keyboard::adminPanel()];
                        }
                        
                        $adminsArr = array_diff($adminsArr, [$remAdminId]);
                        $this->saveSetting('bot_admins', implode(',', $adminsArr));
                        
                        $this->setStep('none');
                        return ["✅ کاربر <code>$remAdminId</code> با موفقیت از لیست ادمین‌ها حذف شد.", Keyboard::adminPanel()];
                    }
                    
                    return ["⚠️ لطفاً از دکمه‌های شیشه‌ای بالا استفاده کنید.", null];       
                // --------------------------------------------------
                //       ➕ افزودن محصول (مسیر جدید ۵ مرحله‌ای)

                // --------------------------------------------------
                //       ➕ افزودن محصول (مسیر ۵ مرحله‌ای نهایی)
                // --------------------------------------------------
                case 'add_plan_location':
                    if ($text == 'back_to_admin_main') {
                        $this->setStep('none');
                        return ["به پنل مدیریت بازگشتید.", Keyboard::adminPanel()];
                    }

                    if (strpos($text, 'adm_loc_') === 0) {
                        $locKey = str_replace('adm_loc_', '', $text); // germany یا uk
                        $locName = ($locKey == 'germany') ? '🇩🇪 آلمان' : '🇬🇧 انگلیس';
                        
                        $this->setStep('add_plan_name', $locKey); // ذخیره لوکیشن در تمپ
                        return ["💾 <b>لوکیشن:</b> $locName\n\n📝 <b>مرحله ۲ از ۵:</b>\nلطفاً <b>نام محصول</b> را وارد کنید:\n(مثال: پرسرعت و پایدار)", Keyboard::cancel()];
                    }
                    return ["⚠️ لطفاً یکی از لوکیشن‌های بالا را انتخاب کنید.", Keyboard::adminSelectLocationForAdd()];
                    
                // مرحله ۲: دریافت نام
case 'add_plan_name':
                    $this->setStep('add_plan_gb', $text); 
                    return ["💾 <b>نام محصول:</b> $text\n\n📝 <b>مرحله ۲ از ۴:</b>\nلطفاً <b>حجم سرویس</b> را به گیگابایت (عدد انگلیسی) وارد کنید:\n(مثال: 20)", Keyboard::cancel()];                    
                // مرحله ۳: دریافت حجم -> نمایش دکمه‌های زمان
case 'add_plan_gb':
                    $gb = $this->cleanNumber($text);
                    if (!is_numeric($gb)) return ["⚠️ لطفاً فقط عدد انگلیسی وارد کنید.", Keyboard::cancel()];
                    
                    $newData = $tempData . "|" . $gb; 
                    $this->setStep('select_duration_for_plan', $newData);
                    return ["💾 <b>حجم:</b> $gb گیگابایت\n\n📝 <b>مرحله ۳ از ۴:</b>\nلطفاً <b>مدت زمان</b> سرویس را از لیست زیر انتخاب کنید:", Keyboard::selectDurationListForAdd()];
                // مرحله ۴: انتخاب زمان (جستجو در دیتابیس با آیدی)
case 'select_duration_for_plan':
                    if ($text == 'new_duration_create') {
                        $this->setStep('add_new_duration_title_flow'); 
                        return ["📝 <b>عنوان</b> زمان جدید را وارد کنید:\nمثال: یک ماهه", Keyboard::backToAdmin()];
                    }
                    if (strpos($text, 'sel_dur_') === 0) {
                        $durId = str_replace('sel_dur_', '', $text); 
                        $stmt = $this->db->prepare("SELECT * FROM durations WHERE id = ?");
                        $stmt->execute([$durId]);
                        $duration = $stmt->fetch(PDO::FETCH_ASSOC);
                        if (!$duration) return ["❌ زمان یافت نشد.", Keyboard::selectDurationListForAdd()];

                        $dTitle = $duration['title'];
                        $dDays = $duration['days'];

                        $newData = $tempData . "|" . $dTitle . "|" . $dDays;
                        $this->setStep('add_plan_price', $newData);
                        return ["💾 <b>مدت زمان:</b> $dTitle ($dDays روز)\n\n📝 <b>مرحله ۴ از ۴:</b>\nلطفاً <b>قیمت</b> را به تومان وارد کنید:\n(مثال: 150000)", Keyboard::cancel()];
                    }
                    return ["⚠️ لطفا یکی از گزینه‌های بالا را انتخاب کنید.", Keyboard::selectDurationListForAdd()];
                    
                // مرحله ۵: قیمت و ذخیره نهایی
case 'add_plan_price':
                    $price = $this->cleanNumber($text);
                    if (!is_numeric($price)) return ["⚠️ لطفاً فقط عدد انگلیسی وارد کنید.", Keyboard::cancel()];

                    $parts = explode('|', $tempData);
                    if (count($parts) < 4) return ["❌ **اطلاعات ناقص است!**\nلطفاً دکمه انصراف را بزنید.", Keyboard::adminPanel()];

                    $name = $parts[0];
                    $gb = $parts[1];
                    $dTitle = $parts[2];
                    $days = $parts[3];

                    // 👈 همه‌چیز به صورت خودکار به عنوان فول اختصاصی (dedicated) ذخیره می‌شود
                    $locationKey = 'dedicated'; 
                    $inboundId = 1; // در هیدیفای اینباند مهم نیست، اما برای پر کردن دیتابیس ۱ می‌ذاریم

                    $this->createPlanInDB($name, $gb, $days, $price, $locationKey, $inboundId, $dTitle);
                    $this->setStep('none');
                    
                    $msg = "✅ <b>محصول جدید با موفقیت ساخته شد!</b>\n\n";
                    $msg .= "💎 <b>نوع:</b> فول اختصاصی\n";
                    $msg .= "🏷 <b>نام:</b> $name\n";
                    $msg .= "📊 <b>حجم:</b> $gb گیگابایت\n";
                    $msg .= "⏳ <b>زمان:</b> $dTitle ($days روز)\n";
                    $msg .= "💰 <b>قیمت:</b> " . number_format($price) . " تومان\n";
                    
                    return [$msg, Keyboard::adminPanel()];
                    // --------------------------------------------------
                //       ⏳ مدیریت ساخت زمان جدید (Flow جداگانه)
                // --------------------------------------------------
                case 'add_new_duration_title_flow':
                    $this->setStep('add_new_duration_days_flow', $text); // ذخیره عنوان
                    return ["📅 تعداد <b>روز</b> اعتبار این زمان را وارد کنید (عدد):\nمثال: 30", Keyboard::backToAdmin()];

                case 'add_new_duration_days_flow':
                    $days = $this->cleanNumber($text);
                    if (!is_numeric($days)) return ["⚠️ فقط عدد وارد کنید.", Keyboard::backToAdmin()];
                    
                    $title = $tempData;
                    // ذخیره در دیتابیس durations
                    $this->db->prepare("INSERT INTO durations (title, days) VALUES (?, ?)")->execute([$title, $days]);
                    
                    $this->setStep('none');
                    return ["✅ زمان <b>$title ($days روز)</b> ساخته شد.\nحالا می‌توانید هنگام افزودن محصول آن را انتخاب کنید.", Keyboard::adminPanel()];

                // حذف زمان (هندلینگ دکمه شیشه‌ای)
                case 'delete_duration_select':
                    if (strpos($text, 'del_dur_id_') === 0) {
                        $id = str_replace('del_dur_id_', '', $text);
                        $this->db->prepare("DELETE FROM durations WHERE id = ?")->execute([$id]);
                        return ["✅ زمان مورد نظر حذف شد.", Keyboard::deleteDurationList()];
                    }
                    return ["منوی مدیریت زمان:", Keyboard::manageDurationsPanel()];
                    
                    // --------------------------------------------------
                //            ❌ منطق مراحل حذف محصول (اینجا باید باشد)
                // --------------------------------------------------
                
                // مرحله ۱: وقتی ادمین روی دکمه زمان (مثلا یک ماهه) کلیک کرد

// --------------------------------------------------
                //       ❌ حذف محصول (مسیر جدید: لوکیشن -> زمان -> محصول)
                // --------------------------------------------------
                
                // مرحله ۱: پردازش انتخاب لوکیشن
                case 'delete_product_select_loc':
                    if ($text == 'back_to_admin_main') {
                        $this->setStep('none');
                        return ["به پنل مدیریت بازگشتید.", Keyboard::adminPanel()];
                    }

                    if (strpos($text, 'del_loc_') === 0) {
                        $locKey = str_replace('del_loc_', '', $text); // germany یا uk
                        $locName = ($locKey == 'germany') ? '🇩🇪 آلمان' : '🇬🇧 انگلیس';
                        
                        $this->setStep('delete_product_select_dur', $locKey); // ذخیره لوکیشن در تمپ
                        return ["🌍 <b>لوکیشن:</b> $locName\n\n📂 لطفاً <b>مدت زمان</b> را انتخاب کنید:", Keyboard::deleteProductDurationList($locKey)];
                    }
                    return ["⚠️ لطفا یک لوکیشن را انتخاب کنید.", Keyboard::adminSelectLocationForDelete()];

                // مرحله ۲: پردازش انتخاب زمان
case 'delete_product_select_dur':
                    if ($text == 'back_to_admin_main' || $text == 'back_to_delete_loc') { // هندل کردن دکمه بازگشت
                         $this->setStep('none');
                         return ["به پنل مدیریت بازگشتید.", Keyboard::adminPanel()];
                    }

                    if (strpos($text, 'del_prod_dur_') === 0) {
                        $durTitle = str_replace('del_prod_dur_', '', $text);
                        $this->setStep('delete_product_final', $durTitle); // فقط زمان رو تو تمپ ذخیره میکنیم
                        
                        return ["🗑 محصولات دسته <b>$durTitle</b>:\n(برای حذف روی محصول کلیک کنید)", Keyboard::deleteProductListByDuration('dedicated', $durTitle)];
                    }
                    return ["⚠️ لطفا یک زمان را انتخاب کنید.", Keyboard::deleteProductDurationList('dedicated')];
                    
                    
                // مرحله ۳: پردازش حذف نهایی محصول
case 'delete_product_final':
                    $durTitle = $tempData;

                    if ($text == 'back_to_delete_dur') {
                         $this->setStep('delete_product_select_dur', 'dedicated');
                         return ["📂 لطفاً <b>مدت زمان</b> را انتخاب کنید:", Keyboard::deleteProductDurationList('dedicated')];
                    }

                    if (strpos($text, 'del_prod_id_') === 0) {
                        $id = str_replace('del_prod_id_', '', $text);
                        
                        $stmt = $this->db->prepare("SELECT name FROM plans WHERE id = ?");
                        $stmt->execute([$id]);
                        $pName = $stmt->fetchColumn();
                        
                        $this->db->prepare("DELETE FROM plans WHERE id = ?")->execute([$id]);
                        
                        return ["✅ محصول <b>$pName</b> با موفقیت حذف شد.", Keyboard::deleteProductListByDuration('dedicated', $durTitle)];
                    }
                    return ["⚠️ گزینه نامعتبر.", Keyboard::deleteProductListByDuration('dedicated', $durTitle)];                    
                    
                    // --------------------------------------------------
                //       📢 قفل کانال (عضویت اجباری)
                // --------------------------------------------------
// --------------------------------------------------
                case 'add_channel_id':
                    $this->setStep('add_channel_link', $text);
                    return ["🔗 لطفاً <b>لینک جوین</b> کانال را بفرستید:\n(اگر کانال عمومی است، لینک پابلیک مثل https://t.me/mychannel و اگر خصوصی است لینک اینوایت را بفرستید)", Keyboard::cancel()];
                    
                case 'add_channel_link':
                    $newData = $tempData . ';;;' . $text; // ChatID;;;Link
                    $this->setStep('add_channel_title', $newData);
                    return ["📝 لطفاً <b>نام دکمه</b> را بنویسید (مثلاً: عضویت در کانال اصلی):", Keyboard::cancel()];
                    
                case 'add_channel_title':
                    $parts = explode(';;;', $tempData);
                    $chatId = $parts[0];
                    $link = $parts[1];
                    $title = $text;
                    
                    $this->db->prepare("INSERT INTO channels (chat_id, link, title) VALUES (?, ?, ?)")->execute([$chatId, $link, $title]);
                    
                    $this->setStep('none');
                    return ["✅ <b>کانال با موفقیت به سیستم قفل اجباری اضافه شد!</b>", Keyboard::adminChannelPanel()];

                case 'delete_channel_select':
                    if ($text == 'back_to_admin_main') {
                        $this->setStep('none');
                        return ["به پنل مدیریت بازگشتید.", Keyboard::adminPanel()];
                    }
                    if (strpos($text, 'del_channel_') === 0) {
                        $id = str_replace('del_channel_', '', $text);
                        $this->db->prepare("DELETE FROM channels WHERE id = ?")->execute([$id]);
                        return ["✅ <b>کانال با موفقیت حذف شد.</b>", Keyboard::deleteChannelList()];
                    }
                    return ["⚠️ لطفا یک کانال را برای حذف انتخاب کنید.", Keyboard::deleteChannelList()];         
                    
                    
                // --------------------------------------------------
                //            🔖 مدیریت تخفیف نمایندگی
                // --------------------------------------------------
                case 'admin_discount_get_id':
                    $targetUserId = $this->cleanNumber($text);
                    if (!is_numeric($targetUserId)) return ["⛔️ لطفاً فقط <b>آیدی عددی</b> وارد کنید.", Keyboard::backToAdmin()];
                    
                    $stmt = $this->db->prepare("SELECT * FROM users WHERE chat_id = ?");
                    $stmt->execute([$targetUserId]);
                    $user = $stmt->fetch(PDO::FETCH_ASSOC);
                    
                    if (!$user) return ["❌ کاربری با این آیدی یافت نشد.", Keyboard::backToAdmin()];
                    
                    $currentDiscount = $user['discount_percent'] ?? 0;
                    $this->setStep('admin_discount_set_percent', $targetUserId);
                    return ["👤 کاربر پیدا شد.\nتخفیف فعلی: $currentDiscount%\n\n✍️ <b>درصد تخفیف جدید</b> را وارد کنید (0 تا 100):", Keyboard::backToAdmin()];

                case 'admin_discount_set_percent':
                    $percent = $this->cleanNumber($text);
                    if (!is_numeric($percent) || $percent < 0 || $percent > 100) return ["⛔️ عدد باید بین 0 تا 100 باشد.", Keyboard::backToAdmin()];
                    
                    $targetUserId = $tempData;
                    $this->db->prepare("UPDATE users SET discount_percent = ? WHERE chat_id = ?")->execute([$percent, $targetUserId]);
                    
                    // اطلاع رسانی به کاربر
                    $this->sendMessageToId($targetUserId, "🎉 تخفیف نمایندگی شما روی <b>$percent%</b> تنظیم شد.");
                    
                    $this->setStep('none');
                    return ["✅ تخفیف کاربر تنظیم شد.", Keyboard::adminPanel()];

                // --------------------------------------------------
                //            💰 مدیریت موجودی (Wallet)
                // --------------------------------------------------
                case 'admin_wallet_get_id':
                    $targetUserId = $this->cleanNumber($text);
                    if (!is_numeric($targetUserId)) return ["⛔️ لطفاً فقط <b>آیدی عددی</b> وارد کنید.", Keyboard::backToAdmin()];
                    
                    $stmt = $this->db->prepare("SELECT * FROM users WHERE chat_id = ?");
                    $stmt->execute([$targetUserId]);
                    $user = $stmt->fetch(PDO::FETCH_ASSOC);
                    
                    if (!$user) return ["❌ کاربری یافت نشد.", Keyboard::backToAdmin()];
                    
                    $curWallet = number_format($user['wallet']);
                    $this->setStep('admin_wallet_set_balance', $targetUserId);
                    return ["👤 موجودی فعلی کاربر: <b>$curWallet تومان</b>\n\n✍️ <b>موجودی جدید</b> را به تومان وارد کنید:", Keyboard::backToAdmin()];

                case 'admin_wallet_set_balance':
                    $newBalance = $this->cleanNumber($text);
                    if (!is_numeric($newBalance)) return ["⛔️ لطفاً فقط عدد وارد کنید.", Keyboard::backToAdmin()];
                    
                    $targetUserId = $tempData;
                    $this->db->prepare("UPDATE users SET wallet = ? WHERE chat_id = ?")->execute([$newBalance, $targetUserId]);
                    $this->sendMessageToId($targetUserId, "💰 موجودی کیف پول شما توسط مدیریت به <b>" . number_format($newBalance) . " تومان</b> تغییر یافت.");
                    
                    $this->setStep('none');
                    return ["✅ موجودی کاربر آپدیت شد.", Keyboard::adminPanel()];

                // --------------------------------------------------
                //            🎟 مدیریت کدهای تخفیف
                // --------------------------------------------------
                case 'admin_coupon_create_code':
                    if (!preg_match('/^[a-zA-Z0-9]+$/', $text)) return ["⛔️ فقط حروف انگلیسی و عدد مجاز است.", Keyboard::backToAdmin()];
                    
                    $stmt = $this->db->prepare("SELECT id FROM coupons WHERE code = ?");
                    $stmt->execute([$text]);
                    if ($stmt->fetch()) return ["❌ این کد تکراری است.", Keyboard::adminCouponPanel()];

                    $this->setStep('admin_coupon_create_percent', $text);
                    return ["✅ نام کد: <b>$text</b>\n\n✍️ <b>درصد تخفیف</b> را وارد کنید (1-100):", Keyboard::backToAdmin()];

                case 'admin_coupon_create_percent':
                    $percent = $this->cleanNumber($text);
                    if (!is_numeric($percent) || $percent < 1 || $percent > 100) return ["⛔️ بین 1 تا 100 وارد کنید.", Keyboard::backToAdmin()];
                    
                    $newData = $tempData . "|" . $percent;
                    $this->setStep('admin_coupon_create_limit', $newData);
                    return ["✅ درصد: $percent%\n\n🔢 <b>تعداد دفعات مجاز</b> استفاده را وارد کنید:", Keyboard::backToAdmin()];

                case 'admin_coupon_create_limit':
                    $limit = $this->cleanNumber($text);
                    if (!is_numeric($limit) || $limit < 1) return ["⛔️ عدد معتبر وارد کنید.", Keyboard::backToAdmin()];

                    $parts = explode('|', $tempData);
                    $code = $parts[0];
                    $percent = $parts[1];
                    
                    $this->db->prepare("INSERT INTO coupons (code, percent, max_uses) VALUES (?, ?, ?)")->execute([$code, $percent, $limit]);
                    
                    $this->setStep('none');
                    return ["✅ کد تخفیف <b>$code</b> با $percent% تخفیف ساخته شد.", Keyboard::adminCouponPanel()];

                case 'admin_coupon_delete_select':
                    if (strpos($text, '🗑') !== false) {
                        $parts = explode(' ', $text);
                        $code = $parts[1] ?? '';
                        if ($code) {
                            $this->db->prepare("DELETE FROM coupons WHERE code = ?")->execute([$code]);
                            return ["✅ کد تخفیف <b>$code</b> حذف شد.", Keyboard::couponListForManage()];
                        }
                    }
                    return ["⛔️ گزینه نامعتبر.", Keyboard::couponListForManage()];

                // --------------------------------------------------
                //            سایر ویرایش‌ها (کارت، متن‌ها)
                // --------------------------------------------------
                case 'edit_card_number':
                    $this->saveSetting('card_number', $this->cleanNumber($text));
                    $this->setStep('none');
                    return ["✅ شماره کارت ذخیره شد.", Keyboard::cardManagementPanel()];

                case 'edit_card_name':
                    $this->saveSetting('card_name', $text);
                    $this->setStep('none');
                    return ["✅ نام صاحب حساب ذخیره شد.", Keyboard::cardManagementPanel()];

                case 'edit_support_id':
                    $this->saveSetting('support_id', $text);
                    $this->setStep('none');
                    return ["✅ آیدی پشتیبانی آپدیت شد.", Keyboard::adminPanel()];

                case 'edit_test_text':
                    $this->saveSetting('test_description', $text);
                    $this->setStep('none');
                    return ["✅ متن تست رایگان آپدیت شد.", Keyboard::adminPanel()];
                
                case 'edit_start_text':
                    $this->saveSetting('start_text', $text);
                    $this->setStep('none');
                    return ["✅ متن پیام استارت (خوش‌آمدگویی) با موفقیت تغییر کرد.", Keyboard::adminPanel()];
                    
                case 'delete_product_select':
                    if (strpos($text, '🗑') !== false) {
                        $namePart = trim(explode(' (', str_replace('🗑 ', '', $text))[0]);
                        $this->db->prepare("DELETE FROM plans WHERE name = ?")->execute([$namePart]);
                        $this->setStep('none');
                        return ["✅ محصول <b>$namePart</b> حذف شد.", Keyboard::adminPanel()];
                    }
                    return ["⚠️ گزینه نامعتبر.", Keyboard::productsListForDelete()];

                // --------------------------------------------------
                //            📢 ارسال همگانی
                // --------------------------------------------------
                case 'get_broadcast_msg':
                    $msgData = ['message_id' => $this->messageId, 'from_chat_id' => $this->chatId];
                    $this->setStep('select_broadcast_method', json_encode($msgData));
                    return ["پیام دریافت شد. روش ارسال را انتخاب کنید:", Keyboard::broadcastMethodPanel()];

                case 'select_broadcast_method':
                    $method = (strpos($text, 'کپی') !== false) ? 'copy' : 'forward';
                    $msgData = json_decode($tempData, true);
                    
                    // شروع ارسال (ساده شده)
                    $users = $this->db->query("SELECT chat_id FROM users")->fetchAll(PDO::FETCH_COLUMN);
                    $count = 0;
                    $this->sendMessageToAdmin("🚀 ارسال شروع شد...");
                    
                    foreach ($users as $uid) {
                        if ($method == 'copy') $this->copyMessage($uid, $msgData['from_chat_id'], $msgData['message_id']);
                        else $this->forwardMessage($uid, $msgData['from_chat_id'], $msgData['message_id']);
                        $count++;
                        if ($count % 50 == 0) usleep(200000); 
                    }
                    
                    $this->setStep('none');
                    return ["✅ ارسال به $count کاربر انجام شد.", Keyboard::adminPanel()];
            }
        }

        // ====================================================
        //              منوی اصلی ادمین (COMMANDS)
        // ====================================================
        switch ($text) {
            
            case '👨‍✈️ مدیریت ادمین‌ها':
                if (!$this->isMainAdmin) {
                    return ["⛔️ شما دسترسی به این بخش را ندارید. (فقط مدیریت کل)", Keyboard::adminPanel()];
                }
                
                $stmt = $this->db->prepare("SELECT value FROM settings WHERE `key` = 'bot_admins'");
                $stmt->execute();
                $currentAdmins = $stmt->fetchColumn();
                $adminsArr = $currentAdmins ? explode(',', $currentAdmins) : [];
                $list = empty($adminsArr) ? "هیچ ادمین فرعی ثبت نشده است." : implode("\n", $adminsArr);
                
                $msg = "👨‍✈️ <b>مدیریت ادمین‌های فرعی</b>\n\n";
                $msg .= "لیست ادمین‌های فعلی:\n<code>$list</code>\n\n";
                $msg .= "👇 جهت افزودن یا حذف ادمین از دکمه‌های زیر استفاده کنید:";
                
                $kb = json_encode(['keyboard' => [
                    ['➕ افزودن ادمین', '🗑 حذف ادمین'],
                    ['🔙 بازگشت به پنل مدیریت']
                ], 'resize_keyboard' => true]);
                return [$msg, $kb];
                
            case '➕ افزودن ادمین':
                if (!$this->isMainAdmin) return ["⛔️ عدم دسترسی.", Keyboard::adminPanel()];
                $this->setStep('awaiting_add_admin_id');
                return ["🆔 <b>آیدی عددی</b> کاربری که می‌خواهید ادمین شود را بفرستید:", Keyboard::cancel()];
                
case '🗑 حذف ادمین':
                if (!$this->isMainAdmin) return ["⛔️ عدم دسترسی.", Keyboard::adminPanel()];
                
                $stmt = $this->db->prepare("SELECT value FROM settings WHERE `key` = 'bot_admins'");
                $stmt->execute();
                $currentAdmins = $stmt->fetchColumn();
                $adminsArr = $currentAdmins ? explode(',', $currentAdmins) : [];
                
                if (empty($adminsArr)) {
                    return ["هیچ ادمین فرعی در ربات ثبت نشده است.", Keyboard::adminPanel()];
                }
                
                // ساخت کیبورد شیشه‌ای از لیست ادمین‌ها
                $kb = ['inline_keyboard' => []];
                foreach ($adminsArr as $adm) {
                    $kb['inline_keyboard'][] = [['text' => "🗑 حذف: $adm", 'callback_data' => "del_admin_$adm"]];
                }
                $kb['inline_keyboard'][] = [['text' => '❌ انصراف', 'callback_data' => 'back_to_admin_main']];
                
                $this->setStep('awaiting_remove_admin_selection');
                return ["👇 لطفاً ادمینی که می‌خواهید حذف کنید را از لیست زیر انتخاب کنید:", json_encode($kb)];
                
            // --- مدیریت قفل کانال ---
case '📢 قفل کانال':
                $this->setStep('none');
                return ["تنظیمات قفل کانال (عضویت اجباری):", Keyboard::adminChannelPanel()];
                
            case '➕ افزودن کانال جدید':
                $this->setStep('add_channel_id');
                $msg = "📢 <b>مرحله ۱ از ۳:</b>\n\n";
                $msg .= "لطفاً <b>آیدی کانال</b> را بفرستید:\n";
                $msg .= "🔹 برای کانال‌های عمومی: <code>@channel_id</code>\n";
                $msg .= "🔹 برای کانال‌های خصوصی: <code>-100123456789</code>\n\n";
                $msg .= "💡 <b>راهنمایی:</b> برای پیدا کردن آیدی عددی کانال خصوصی، یک پیام از کانال خود به ربات @userinfobot فوروارد کنید تا آیدی کانال را به شما بدهد.\n\n";
                $msg .= "⚠️ <b>بسیار مهم:</b> ربات باید حتماً در این کانال <b>ادمین</b> باشد تا بتواند عضویت کاربر را بررسی کند!";
                return [$msg, Keyboard::cancel()];
                
            case '🗑 حذف کانال':
                $this->setStep('delete_channel_select');
                return ["کدام کانال از لیست قفل حذف شود؟", Keyboard::deleteChannelList()];                
// استارت مسیر ۵ مرحله‌ای افزودن محصول جدید
case '➕ افزودن محصول جدید':
                $this->setStep('add_plan_name');
                return ["📝 <b>مرحله ۱ از ۴:</b>\n\nلطفاً <b>نام محصول</b> را وارد کنید:\n(مثال: پرسرعت و پایدار)", Keyboard::cancel()];                
            case '⏳ مدیریت زمان‌ها': 
                return ["مدیریت زمان‌های قابل انتخاب:", Keyboard::manageDurationsPanel()];

            case '➕ افزودن زمان جدید': // اگر از منوی مدیریت زمان آمد
            case 'new_duration_create':
                $this->setStep('add_new_duration_title_flow');
                return ["📝 <b>عنوان</b> زمان جدید را وارد کنید:\nمثال: سه ماهه", Keyboard::backToAdmin()];
            
            case '🗑 حذف زمان':
            case 'delete_duration_list':
                 $this->setStep('delete_duration_select');
                 return ["کدام زمان حذف شود؟", Keyboard::deleteDurationList()];

// دکمه شروع حذف محصول در منوی اصلی
case '❌ حذف محصول':
                $this->setStep('delete_product_select_dur', 'dedicated');
                return ["📂 لطفاً <b>مدت زمان</b> مورد نظر برای حذف محصول را انتخاب کنید:", Keyboard::deleteProductDurationList('dedicated')];
                
                // --- مالی ---
            case '💰 مدیریت موجودی':
                $this->setStep('admin_wallet_get_id');
                return ["🆔 لطفاً <b>آیدی عددی</b> کاربر را ارسال کنید:", Keyboard::backToAdmin()];

            case '💳 ویرایش شماره کارت':
                return ["چه چیزی را ویرایش می‌کنید؟", Keyboard::cardManagementPanel()];
            
            case '🔢 تغییر شماره کارت': $this->setStep('edit_card_number'); return ["🔢 شماره کارت جدید:", Keyboard::cancel()];
            case '👤 تغییر نام صاحب حساب': $this->setStep('edit_card_name'); return ["👤 نام صاحب حساب:", Keyboard::cancel()];

            // --- تخفیف ---
            case '🔖 تخفیف نمایندگی':
                $this->setStep('admin_discount_get_id');
                return ["🆔 آیدی عددی کاربر را وارد کنید:", Keyboard::backToAdmin()];

            case '🎟 کد تخفیف':
                return ["مدیریت کدهای تخفیف:", Keyboard::adminCouponPanel()];
            
            case '➕ ساخت کد تخفیف':
                $this->setStep('admin_coupon_create_code');
                return ["✍️ <b>نام کد</b> را وارد کنید (انگلیسی):", Keyboard::backToAdmin()];
            
            case '⚙️ مدیریت کد تخفیف ها':
                $this->setStep('admin_coupon_delete_select');
                return ["👇 برای حذف کلیک کنید:", Keyboard::couponListForManage()];

            // --- تنظیمات ---
            case '🆔 ویرایش آیدی پشتیبانی': $this->setStep('edit_support_id'); return ["🆔 آیدی جدید:", Keyboard::cancel()];
            case '✏️ ویرایش متن تست': $this->setStep('edit_test_text'); return ["📝 متن جدید:", Keyboard::cancel()];
            case '📝 ویرایش متن استارت': 
                $this->setStep('edit_start_text'); 
                return ["📝 لطفاً <b>متن جدید پیام استارت (خوش‌آمدگویی)</b> را بفرستید:\n\n💡 میتوانید از ایموجی‌ها و اینتر استفاده کنید.", Keyboard::cancel()];
                
            case '📢 ارسال همگانی':
                $this->setStep('get_broadcast_msg');
                return ["📢 پیام خود را بفرستید (متن، عکس، فوروارد...):", Keyboard::cancel()];

            case '📊 آمار ربات':
                 $users = $this->db->query("SELECT COUNT(*) FROM users")->fetchColumn();
                 $orders = $this->db->query("SELECT COUNT(*) FROM orders")->fetchColumn();
                 $rev = $this->db->query("SELECT SUM(total_price) FROM orders")->fetchColumn() ?: 0;
                 
                 $msg = "📊 <b>آمار کلی ربات:</b>\n\n";
                 $msg .= "👤 کاربران: <b>$users نفر</b>\n";
                 $msg .= "🛍 فروش کل: <b>$orders عدد</b>\n";
                 $msg .= "💰 درآمد کل: <b>" . number_format($rev) . " تومان</b>";
                 
                 return [$msg, Keyboard::adminPanel()];

            case '⚙️ پنل مدیریت': 
                return ["⚙️ پنل مدیریت:", Keyboard::adminPanel()];

            default:
                return ["⛔️ دستور نامعتبر.", Keyboard::adminPanel()];
        }
    }

    // ====================================================
    //                توابع کمکی (Helpers)
    // ====================================================

    private function cleanNumber($string) {
        $string = str_replace(',', '', $string);
        $persian = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
        $arabic = ['٠', '١', '٢', '٣', '٤', '٥', '٦', '٧', '٨', '٩'];
        $num = range(0, 9);
        $converted = str_replace($persian, $num, $string);
        return str_replace($arabic, $num, $converted);
    }

    private function saveSetting($key, $val) {
        $stmt = $this->db->prepare("INSERT INTO settings (`key`, `value`) VALUES (?, ?) ON DUPLICATE KEY UPDATE value = ?");
        $stmt->execute([$key, $val, $val]);
    }

    // ✅ تابع ذخیره محصول (با اضافه شدن durationTitle)
    private function createPlanInDB($name, $gb, $days, $price, $location, $inboundId, $durationTitle) {
        $stmt = $this->db->prepare("INSERT INTO plans (name, location, duration_title, price, volume_gb, days, inbound_id, is_active) VALUES (?, ?, ?, ?, ?, ?, ?, 1)");
        $stmt->execute([$name, $location, $durationTitle, $price, $gb, $days, $inboundId]);
    }

    // ====================================================
    //                توابع تلگرام (Telegram)
    // ====================================================

    private function sendMessageToAdmin($text, $kb = null) {
        return $this->req('sendMessage', ['chat_id' => $this->chatId, 'text' => $text, 'parse_mode' => 'HTML', 'reply_markup' => $kb]);
    }

    private function sendMessageToId($chatId, $text) {
        return $this->req('sendMessage', ['chat_id' => $chatId, 'text' => $text, 'parse_mode' => 'HTML']);
    }

    private function copyMessage($chatId, $fromChatId, $messageId) {
        return $this->req('copyMessage', ['chat_id' => $chatId, 'from_chat_id' => $fromChatId, 'message_id' => $messageId]);
    }

    private function forwardMessage($chatId, $fromChatId, $messageId) {
        return $this->req('forwardMessage', ['chat_id' => $chatId, 'from_chat_id' => $fromChatId, 'message_id' => $messageId]);
    }

    private function req($method, $datas) {
        // اطمینان از ارسال به صورت HTML
        $datas['parse_mode'] = 'HTML';
        
        $ch = curl_init("https://api.telegram.org/bot" . Config::BOT_TOKEN . "/$method");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $datas);
        $res = curl_exec($ch);
        curl_close($ch);
        return json_decode($res, true);
    }
}