<?php
namespace App\Helpers;

use App\Models\Database;
use PDO;

class Keyboard {
    
    // =================================================================
    //                         بخش منوی اصلی ربات
    // =================================================================

    // منوی اصلی (دستورات پایین صفحه)
public static function mainMenu($isAdmin = false) {
        $keyboard = [
            ['🛍 خرید سرویس', '🔥 تست رایگان'],
            ['🔎 استعلام', '👱 سرویس های من'],
            ['💰 کیف پول', '🆔 آیدی من'],
            ['🤝 زیرمجموعه گیری', '📚 آموزش ها'], // 👈 این دکمه اضافه شد
            ['👨‍💻 پشتیبانی', '🤝 درخواست نمایندگی']
        ];

        if ($isAdmin) {
            $keyboard[] = ['⚙️ پنل مدیریت'];
        }

        return json_encode([
            'keyboard' => $keyboard,
            'resize_keyboard' => true
        ]);
    }

    // =================================================================
    //                         بخش پنل مدیریت (Admin)
    // =================================================================

public static function adminPanel() {
        return json_encode([
            'keyboard' => [
                ['💰 مدیریت موجودی', '➕ افزودن محصول جدید'],
                ['⏳ مدیریت زمان‌ها', '❌ حذف محصول'],
                ['🔖 تخفیف نمایندگی', '🎟 کد تخفیف'],
                ['📢 ارسال همگانی', '📊 آمار ربات'],
                ['💳 ویرایش شماره کارت', '🆔 ویرایش آیدی پشتیبانی'],
                ['📢 قفل کانال', '✏️ ویرایش متن تست'], // دکمه جدید اضافه شد
                ['👨‍✈️ مدیریت ادمین‌ها','📝 ویرایش متن استارت'],                ['🔙 بازگشت به پنل کاربری']
            ],
            'resize_keyboard' => true
        ]);
    }
    
    // منوی مدیریت لوکیشن (زیرمنو)
    public static function locationPanel() {
        return json_encode([
            'keyboard' => [
                [['text' => '➕ افزودن لوکیشن'], ['text' => '🗑 حذف لوکیشن']],
                [['text' => '🔙 بازگشت به پنل مدیریت']]
            ],
            'resize_keyboard' => true
        ]);
    }

    // منوی مدیریت زمان (زیرمنو)
    public static function durationPanel() {
        return json_encode([
            'keyboard' => [
                [['text' => '➕ افزودن زمان'], ['text' => '🗑 حذف زمان']],
                [['text' => '🔙 بازگشت به پنل مدیریت']]
            ],
            'resize_keyboard' => true
        ]);
    }

    // منوی مدیریت کارت بانکی (زیرمنو)
    public static function cardManagementPanel() {
        return json_encode([
            'keyboard' => [
                [['text' => '🔢 تغییر شماره کارت'], ['text' => '👤 تغییر نام صاحب حساب']],
                [['text' => '🔙 بازگشت به پنل مدیریت']]
            ],
            'resize_keyboard' => true
        ]);
    }
    
    // دکمه بازگشت به پنل مدیریت (مخصوص مراحل داخلی ادمین)
    public static function backToAdmin() {
        return json_encode([
            'keyboard' => [
                [['text' => '🔙 بازگشت به پنل مدیریت']]
            ],
            'resize_keyboard' => true
        ]);
    }

    // لیست دکمه‌ای لوکیشن‌ها (جهت انتخاب ادمین هنگام حذف)
    public static function selectLocationList() {
        $db = Database::getInstance();
        $stmt = $db->query("SELECT name FROM locations");
        $locs = $stmt->fetchAll(PDO::FETCH_COLUMN);
        
        $buttons = [];
        $row = [];
        foreach ($locs as $l) {
            $row[] = ['text' => $l];
            if (count($row) == 2) {
                $buttons[] = $row;
                $row = [];
            }
        }
        if (!empty($row)) $buttons[] = $row;
        
        $buttons[] = [['text' => '🔙 بازگشت به پنل مدیریت']];
        
        return json_encode(['keyboard' => $buttons, 'resize_keyboard' => true]);
    }

    // لیست دکمه‌ای زمان‌ها (جهت انتخاب ادمین هنگام حذف)
    public static function selectDurationList() {
        $db = Database::getInstance();
        $stmt = $db->query("SELECT title FROM durations");
        $durs = $stmt->fetchAll(PDO::FETCH_COLUMN);
        
        $buttons = [];
        $row = [];
        foreach ($durs as $d) {
            $row[] = ['text' => $d];
            if (count($row) == 2) {
                $buttons[] = $row;
                $row = [];
            }
        }
        if (!empty($row)) $buttons[] = $row;
        
        $buttons[] = [['text' => '🔙 بازگشت به پنل مدیریت']];
        
        return json_encode(['keyboard' => $buttons, 'resize_keyboard' => true]);
    }

    // لیست محصولات برای حذف (مخصوص ادمین)
    public static function productsListForDelete() {
        $db = Database::getInstance();
        // فقط نام‌های یکتا را می‌گیریم چون حذف گروهی است
        $stmt = $db->query("SELECT DISTINCT name FROM plans WHERE is_active = 1");
        $plans = $stmt->fetchAll(PDO::FETCH_COLUMN);

        $buttons = [];
        foreach ($plans as $name) {
            $buttons[] = [['text' => "🗑 " . $name]];
        }
        $buttons[] = [['text' => '🔙 بازگشت به پنل مدیریت']];

        return json_encode([
            'keyboard' => $buttons,
            'resize_keyboard' => true
        ]);
    }

    // منوی انتخاب روش ارسال همگانی
    public static function broadcastMethodPanel() {
        return json_encode([
            'keyboard' => [
                [['text' => '📋 کپی (بدون نام فرستنده)'], ['text' => '🔄 فوروارد (با نام فرستنده)']],
                [['text' => '❌ انصراف']]
            ],
            'resize_keyboard' => true
        ]);
    }

    // =================================================================
    //                 بخش پروسه خرید کاربر (3 مرحله‌ای)
    // =================================================================

// 1. لیست نوع سرویس (مرحله اول خرید)
    public static function serviceTypeList() {
        return json_encode([
            'inline_keyboard' => [
                [
                    ['text' => '💎 فول اختصاصی', 'callback_data' => 'srv_dedicated']
                ],
                [
                    ['text' => '🔙 بازگشت', 'callback_data' => 'back_to_main_menu']
                ]
            ]
        ]);
    }

    // 2. لیست لوکیشن‌ها (مرحله دوم خرید)
    public static function locationsList() {
        return json_encode([
            'inline_keyboard' => [
                [
                    ['text' => '🇩🇪 آلمان', 'callback_data' => 'loc_germany'],
                    ['text' => '🇬🇧 انگلیس', 'callback_data' => 'loc_uk']
                ],
                [
                    ['text' => '🔙 بازگشت', 'callback_data' => 'back_to_service_type'] // برمیگرده به نوع سرویس
                ]
            ]
        ]);
    }
    
    // مرحله 2: لیست زمان‌ها (بر اساس لوکیشن انتخاب شده)
// لیست زمان‌ها برای کاربر (مرحله بعد از انتخاب کشور)
    public static function durationsList($location) {
        $db = \App\Models\Database::getInstance();
        // جستجو در دیتابیس بر اساس لوکیشن (uk یا germany)
        $stmt = $db->prepare("SELECT DISTINCT duration_title, days FROM plans WHERE location = ? AND is_active = 1 ORDER BY days ASC");
        $stmt->execute([$location]);
        $rows = $stmt->fetchAll();
        
        $buttons = [];
        foreach ($rows as $row) {
            // فرمت دیتا: dur_لوکیشن|زمان
            $buttons[] = [['text' => "⏳ " . $row['duration_title'], 'callback_data' => 'dur_' . $location . '|' . $row['duration_title']]];
        }
        $buttons[] = [['text' => '🔙 بازگشت', 'callback_data' => 'back_to_main']];
        
        return json_encode(['inline_keyboard' => $buttons]);
    }
// مرحله 3: لیست پلن‌ها (اصلاح شده: نمایش حجم و قیمت)
// لیست حجم‌ها و قیمت‌ها برای کاربر (مرحله آخر خرید)
    public static function plansList($location, $durationTitle) {
        $db = \App\Models\Database::getInstance();
        // دریافت دقیق محصولات همان لوکیشن و همان زمان
        $stmt = $db->prepare("SELECT * FROM plans WHERE location = ? AND duration_title = ? AND is_active = 1 ORDER BY volume_gb ASC");
        $stmt->execute([$location, $durationTitle]);
        $rows = $stmt->fetchAll();
        
        $buttons = [];
        foreach ($rows as $row) {
            $price = number_format($row['price']);
            $buttons[] = [['text' => "📦 {$row['volume_gb']} گیگابایت - $price تومان", 'callback_data' => 'buy_plan_' . $row['id']]];
        }
        // دکمه بازگشت به لیست زمان‌های همان کشور
        $buttons[] = [['text' => '🔙 بازگشت', 'callback_data' => 'loc_' . $location]];
        
        return json_encode(['inline_keyboard' => $buttons]);
    }
    // =================================================================
    //                       سایر دکمه‌های کمکی
    // =================================================================

// ==========================================
    // اصلاح تابع دکمه‌های فاکتور (با دکمه بازگشت)
    // ==========================================
public static function invoiceButtons($planId, $price, $backData, $hasCoupon = false) {
        $db = \App\Models\Database::getInstance();
        $stmt = $db->query("SELECT value FROM settings WHERE `key` = 'support_id'");
        $supId = $stmt->fetchColumn() ?: '@Admin';
        $supLink = "https://t.me/" . ltrim($supId, '@');

        $keyboard = [];

        // ردیف اول: پرداخت کارت و کیف پول
        $keyboard[] = [
            ['text' => "💳 کارت به کارت - " . number_format($price), 'callback_data' => "pay_card_$planId"]
        ];
        $keyboard[] = [
            ['text' => "🏦 پرداخت با کیف پول", 'callback_data' => "pay_wallet_$planId"]
        ];

        // ردیف دوم: دکمه کد تخفیف (اگر کد نزده باشد)
        if (!$hasCoupon) {
            $keyboard[] = [
                ['text' => "🎟 ثبت کد تخفیف", 'callback_data' => "enter_coupon_$planId"]
            ];
        } else {
            $keyboard[] = [
                ['text' => "❌ حذف کد تخفیف", 'callback_data' => "remove_coupon_$planId"]
            ];
        }

        // ردیف سوم: پشتیبانی و بازگشت
        $keyboard[] = [
            ['text' => "پیام به پشتیبان", 'url' => $supLink]
        ];
        $keyboard[] = [
            ['text' => "🔙 بازگشت به لیست پلن‌ها", 'callback_data' => $backData]
        ];

        return json_encode(['inline_keyboard' => $keyboard]);
    }
    
    // ==========================================
    // لیست زمان‌ها برای ادمین (مخصوص افزودن محصول)
    // ==========================================
// 1. کیبورد لیست زمان‌ها برای انتخاب در هنگام افزودن محصول
public static function selectDurationListForAdd() {
        $db = \App\Models\Database::getInstance();
        $rows = $db->query("SELECT * FROM durations ORDER BY days ASC")->fetchAll();
        
        $buttons = [];
        foreach ($rows as $row) {
            // نکته طلایی اینجاست: باید id ارسال بشه نه title
            $buttons[] = [['text' => $row['title'], 'callback_data' => 'sel_dur_' . $row['id']]];
        }
        
        $buttons[] = [['text' => '➕ تعریف زمان جدید', 'callback_data' => 'new_duration_create']];
        $buttons[] = [['text' => '❌ انصراف', 'callback_data' => 'back_to_admin_main']];
        
        return json_encode(['inline_keyboard' => $buttons]);
    }
    

    
    // 2. پنل مدیریت زمان‌ها (حذف و اضافه)
    public static function manageDurationsPanel() {
        return json_encode(['inline_keyboard' => [
            [['text' => '➕ افزودن زمان جدید', 'callback_data' => 'new_duration_create']],
            [['text' => '🗑 حذف زمان', 'callback_data' => 'delete_duration_list']],
            [['text' => '🔙 بازگشت', 'callback_data' => 'back_to_admin_main']]
        ]]);
    }

    // 3. لیست زمان‌ها برای حذف
    public static function deleteDurationList() {
        $db = \App\Models\Database::getInstance();
        $rows = $db->query("SELECT * FROM durations")->fetchAll();
        
        $buttons = [];
        foreach ($rows as $row) {
            $buttons[] = [['text' => "🗑 " . $row['title'], 'callback_data' => 'del_dur_id_' . $row['id']]];
        }
        $buttons[] = [['text' => '🔙 بازگشت', 'callback_data' => 'back_to_admin_main']];
        
        return json_encode(['inline_keyboard' => $buttons]);
    }
    // دکمه دریافت تست رایگان
   public static function testInline() {
        return json_encode([
            'inline_keyboard' => [
                [
                    ['text' => '🚀 دریافت تست رایگان (3 ساعت)', 'callback_data' => 'get_free_test']
                ]
            ]
        ]);
    }

    // دکمه بازگشت ساده (کیبورد پایین)
    public static function backOnly() {
        return json_encode(['keyboard' => [[['text' => '🔙 بازگشت']]], 'resize_keyboard' => true]);
    }
    
    // دکمه انصراف (کیبورد پایین صفحه)
    public static function cancel() {
        return json_encode([
            'keyboard' => [
                [['text' => '❌ انصراف']]
            ],
            'resize_keyboard' => true
        ]);
    }
    
    // لیست سرویس‌های خریداری شده کاربر
    public static function userServicesList($userId) {
        $db = Database::getInstance();
        
        // 1. حذف شرط status='completed' تا همه سفارش‌ها نمایش داده شوند
        // 2. استفاده از LEFT JOIN تا اگر پلن حذف شده بود، سفارش غیب نشود
        $stmt = $db->prepare("SELECT orders.*, plans.name as plan_name 
                              FROM orders 
                              LEFT JOIN plans ON orders.plan_id = plans.id 
                              WHERE orders.user_id = ? 
                              ORDER BY orders.id DESC LIMIT 20");
        
        $stmt->execute([$userId]);
        $orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

        $buttons = [];
        if ($orders && count($orders) > 0) {
            foreach ($orders as $order) {
                // اگر پلن حذف شده بود، اسمش را دستی مینویسیم
                $pName = $order['plan_name'] ?? "سرویس قدیمی";
                
                // تاریخ خرید
                $date = date("Y/m/d", strtotime($order['created_at']));
                
                $btnText = "💎 $pName ($date)";
                $buttons[] = [['text' => $btnText, 'callback_data' => "my_service_" . $order['id']]];
            }
        } else {
            $buttons[] = [['text' => '❌ هنوز خریدی ثبت نشده است', 'callback_data' => 'none']];
        }

        $buttons[] = [['text' => '🔙 بازگشت', 'callback_data' => 'back_to_main_menu']];

        return json_encode(['inline_keyboard' => $buttons]);
    }

    // منوی انتخاب سیستم عامل برای آموزش
    public static function tutorialsPanel() {
        return json_encode([
            'inline_keyboard' => [
                [['text' => '🤖 اندروید (Android)', 'callback_data' => 'tut_android']],
                [['text' => '🍎 آیفون (iOS)', 'callback_data' => 'tut_ios']],
                [['text' => '💻 ویندوز (Windows)', 'callback_data' => 'tut_windows']],
                [['text' => '🍏 مک بوک (Mac)', 'callback_data' => 'tut_mac']],
                [['text' => '🔙 بازگشت', 'callback_data' => 'back_to_main_menu']]
            ]
        ]);
    }

    // دکمه بازگشت به لیست آموزش‌ها (زیر هر آموزش نمایش داده می‌شود)
    public static function backToTutorials() {
        return json_encode([
            'inline_keyboard' => [
                [['text' => '🔙 بازگشت به لیست آموزش‌ها', 'callback_data' => 'show_tutorials_menu']]
            ]
        ]);
    }
    
    // پنل مدیریت کد تخفیف (زیرمنو)
    public static function adminCouponPanel() {
        return json_encode([
            'keyboard' => [
                [['text' => '➕ ساخت کد تخفیف'], ['text' => '⚙️ مدیریت کد تخفیف ها']],
                [['text' => '🔙 بازگشت به پنل مدیریت']]
            ],
            'resize_keyboard' => true
        ]);
    }

    // لیست کدهای تخفیف برای حذف (همراه با آمار)
    public static function couponListForManage() {
        $db = \App\Models\Database::getInstance();
        $stmt = $db->query("SELECT * FROM coupons ORDER BY id DESC");
        $coupons = $stmt->fetchAll(\PDO::FETCH_ASSOC);
        
        $buttons = [];
        foreach ($coupons as $c) {
            // نمایش: 🗑 CODE (10%) - 5/100
            $stats = "{$c['used_count']}/{$c['max_uses']}";
            $text = "🗑 {$c['code']} ({$c['percent']}%) - [$stats]";
            $buttons[] = [['text' => $text]];
        }
        
        $buttons[] = [['text' => '🔙 بازگشت']]; // بازگشت به منوی تخفیف
        
        return json_encode(['keyboard' => $buttons, 'resize_keyboard' => true]);
    }
    
    // انتخاب لوکیشن برای افزودن محصول در پنل مدیریت
    public static function adminSelectLocationForAdd() {
        return json_encode([
            'inline_keyboard' => [
                [
                    ['text' => '🇩🇪 آلمان', 'callback_data' => 'adm_loc_germany'],
                    ['text' => '🇬🇧 انگلیس', 'callback_data' => 'adm_loc_uk']
                ],
                [
                    ['text' => '❌ انصراف', 'callback_data' => 'back_to_admin_main']
                ]
            ]
        ]);
    }
    
    // 1. انتخاب لوکیشن برای حذف محصول
    public static function adminSelectLocationForDelete() {
        return json_encode([
            'inline_keyboard' => [
                [
                    ['text' => '🇩🇪 آلمان', 'callback_data' => 'del_loc_germany'],
                    ['text' => '🇬🇧 انگلیس', 'callback_data' => 'del_loc_uk']
                ],
                [
                    ['text' => '❌ انصراف', 'callback_data' => 'back_to_admin_main']
                ]
            ]
        ]);
    }

    // 2. لیست زمان‌ها برای حذف (فیلتر شده بر اساس لوکیشن)
    public static function deleteProductDurationList($location) {
        $db = \App\Models\Database::getInstance();
        $stmt = $db->prepare("SELECT DISTINCT duration_title FROM plans WHERE location = ? AND is_active = 1");
        $stmt->execute([$location]);
        $rows = $stmt->fetchAll();
        
        $buttons = [];
        foreach ($rows as $row) {
            $buttons[] = [['text' => "📂 " . $row['duration_title'], 'callback_data' => 'del_prod_dur_' . $row['duration_title']]];
        }
        $buttons[] = [['text' => '🔙 بازگشت', 'callback_data' => 'back_to_delete_loc']]; // دکمه برگشت به لوکیشن
        
        return json_encode(['inline_keyboard' => $buttons]);
    }

    // 3. لیست محصولات برای حذف (فیلتر شده بر اساس لوکیشن و زمان)
    public static function deleteProductListByDuration($location, $durationTitle) {
        $db = \App\Models\Database::getInstance();
        $stmt = $db->prepare("SELECT * FROM plans WHERE location = ? AND duration_title = ? AND is_active = 1");
        $stmt->execute([$location, $durationTitle]);
        $rows = $stmt->fetchAll();
        
        $buttons = [];
        foreach ($rows as $row) {
            $price = number_format($row['price']);
            $buttons[] = [['text' => "🗑 {$row['name']} ($price)", 'callback_data' => 'del_prod_id_' . $row['id']]];
        }
        $buttons[] = [['text' => '🔙 بازگشت', 'callback_data' => 'back_to_delete_dur']]; // دکمه برگشت به زمان
        
        return json_encode(['inline_keyboard' => $buttons]);
    }
    
    // ==========================================
    //            کیبوردهای قفل کانال
    // ==========================================

    // 1. پنل مدیریت قفل کانال برای ادمین
    public static function adminChannelPanel() {
        return json_encode([
            'keyboard' => [
                ['➕ افزودن کانال جدید', '🗑 حذف کانال'],
                ['🔙 بازگشت']
            ],
            'resize_keyboard' => true
        ]);
    }

    // 2. لیست کانال‌ها برای حذف توسط ادمین
    public static function deleteChannelList() {
        $db = \App\Models\Database::getInstance();
        $rows = $db->query("SELECT * FROM channels")->fetchAll();
        
        $buttons = [];
        foreach ($rows as $row) {
            $buttons[] = [['text' => "🗑 " . $row['title'], 'callback_data' => 'del_channel_' . $row['id']]];
        }
        $buttons[] = [['text' => '🔙 بازگشت', 'callback_data' => 'back_to_admin_main']];
        
        return json_encode(['inline_keyboard' => $buttons]);
    }

    // 3. کیبورد عضویت اجباری که به کاربر نمایش داده می‌شود
    public static function mandatoryJoinKeyboard($channels) {
        $buttons = [];
        
        // ساخت دکمه شیشه‌ای برای هر کانال
        foreach ($channels as $channel) {
            $buttons[] = [['text' => "📢 " . $channel['title'], 'url' => $channel['link']]];
        }
        
        // دکمه تایید عضویت در انتهای لیست
        $buttons[] = [['text' => '✅ عضو شدم', 'callback_data' => 'check_join']];
        
        return json_encode(['inline_keyboard' => $buttons]);
    }
    
    
}