<?php
namespace App\Helpers;

class Logger {
    public static function log($message, $level = 'INFO') {
        $date = date('Y-m-d');
        $time = date('H:i:s');
        $logFile = __DIR__ . "/../../logs/log_$date.txt";
        
        $entry = "[$time] [$level]: " . print_r($message, true) . PHP_EOL;
        file_put_contents($logFile, $entry, FILE_APPEND);
    }

    public static function error($message) {
        self::log($message, 'ERROR');
    }
}
