<?php
namespace App\Helpers;

use App\Config\Config;

class V2RayPanel {
    
    private $apiUrl;

    public function __construct() {
        // ساخت لینک پایه API هیدیفای بر اساس اطلاعات Config.php
        $domain = Config::HIDDIFY_DOMAIN;
        $adminPath = Config::HIDDIFY_ADMIN_PATH;
        $adminSecret = Config::HIDDIFY_ADMIN_SECRET;
        
        $this->apiUrl = "https://{$domain}/{$adminPath}/{$adminSecret}/api/v1/user/";
    }

    /**
     * تابع اضافه کردن کاربر جدید به هیدیفای
     * (پارامتر inboundId اینجا استفاده نمی‌شود چون هیدیفای خودش همه‌چیز را هوشمند مدیریت می‌کند)
     */
    public function addUser($inboundId, $username, $volume, $days, $uuid = null) {
        // اگر UUID ارسال نشده بود، یکی می‌سازیم
        if (!$uuid) {
            $uuid = $this->generateUuid();
        }

        // دیتای استاندارد هیدیفای
        $userData = [
            "uuid" => $uuid,
            "name" => $username,
            "usage_limit_GB" => (float)$volume,
            "package_days" => (int)$days,
            "mode" => "no_reset", // بدون ریست شدن
            "comment" => "ساخته شده توسط ربات",
            "enable" => true
        ];

        $ch = curl_init($this->apiUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($userData));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Accept: application/json'
        ]);
        // غیرفعال کردن چک SSL برای جلوگیری از خطاهای گواهینامه سرور
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        // اگر 200 یا 201 بود یعنی موفقیت‌آمیز ساخته شده
        if ($httpCode == 200 || $httpCode == 201) {
            return ['success' => true, 'uuid' => $uuid];
        }

        return ['success' => false, 'error' => $response];
    }

/**
     * تابع دریافت اطلاعات مصرف یک کاربر (هیدیفای)
     */
    public function getUserStats($uuid) {
        // دریافت کل لیست کاربران برای اطمینان ۱۰۰٪ از پیدا شدن کاربر
        $ch = curl_init($this->apiUrl); 
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Accept: application/json'
        ]);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); // 👈 پشتیبانی از ریدایرکت‌های هیدیفای

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($httpCode == 200 || $httpCode == 201) {
            $users = json_decode($response, true);
            if (is_array($users)) {
                // جستجو در بین کاربران
                foreach ($users as $u) {
                    if (isset($u['uuid']) && strtolower($u['uuid']) == strtolower($uuid)) {
                        return $u; // اطلاعات دقیق کاربر پیدا شد
                    }
                }
            }
        }
        return null; // کاربر یافت نشد
    }
    /**
     * تولید UUID یکتا و استاندارد
     */
    public function generateUuid() {
        try {
            $data = random_bytes(16);
            $data[6] = chr(ord($data[6]) & 0x0f | 0x40); // نسخه 4
            $data[8] = chr(ord($data[8]) & 0x3f | 0x80); // واریانت
            return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
        } catch (\Exception $e) {
            // روش جایگزین در صورتی که سرور random_bytes را پشتیبانی نکند
            return sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
                mt_rand(0, 0xffff), mt_rand(0, 0xffff),
                mt_rand(0, 0xffff),
                mt_rand(0, 0x0fff) | 0x4000,
                mt_rand(0, 0x3fff) | 0x8000,
                mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff)
            );
        }
    }
}