<?php
// Autoloader ساده برای اینکه نیازی به کامپوزر نباشد
spl_autoload_register(function ($class) {
    $prefix = 'App\\';
    $base_dir = __DIR__ . '/../app/';
    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) return;
    $relative_class = substr($class, $len);
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';
    if (file_exists($file)) require $file;
});

use App\Controllers\BotController;
use App\Helpers\Logger;

try {
    $content = file_get_contents("php://input");
    $update = json_decode($content, true);

    if (!$update) {
        echo "Silence is golden.";
        exit;
    }

    $bot = new BotController($update);
    $bot->handle();

} catch (Exception $e) {
    Logger::error("System Error: " . $e->getMessage());
}
